/**
* @package JoomLead TPL Based On Helix3 Framework
* Template Name - JoomLead TPL
* @author JoomLead http://www.joomlead.com
* @copyright Copyright (c)- 2015 JoomLead
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
jQuery(function($) {
  new WOW().init();
  var $body = $('body'),
  $wrapper = $('.body-innerwrapper'),
  $toggler = $('#offcanvas-toggler'),
  $close = $('.close-offcanvas'),
  $offCanvas = $('.offcanvas-menu');

  $toggler.on('click', function(event){
    event.preventDefault();
    stopBubble (event);
    setTimeout(offCanvasShow, 50);
  });

  $close.on('click', function(event){
    event.preventDefault();
    offCanvasClose();
  });

  var offCanvasShow = function(){
    $body.addClass('offcanvas');
    $wrapper.on('click',offCanvasClose);
    $close.on('click',offCanvasClose);
    $offCanvas.on('click',stopBubble);

  };

  var offCanvasClose = function(){
    $body.removeClass('offcanvas');
    $wrapper.off('click',offCanvasClose);
    $close.off('click',offCanvasClose);
    $offCanvas.off('click',stopBubble);
  };

  var stopBubble = function (e) {
    e.stopPropagation();
    return true;
  };
  // ******* Menu link ******** //
  var homeSectionId = $('#sp-page-builder > .page-content > section:first-child').attr('id');   // home section id

  //if (homeSectionId) { var homeSectionId = homeSectionId } else { var homeSectionId = onePageUrl }

  $('.sp-megamenu-wrapper ul, .nav.menu').find('li:not(".no-scroll")').each(function(i, el) {
    var $that    = $(this),
    $anchor  = $that.children('a'),
    url      = $anchor.attr('href'),
    splitUrl = url.split('#');

    if ($that.hasClass('home')) {
      if (homeSectionId) {
        $anchor.attr('href',onePageUrl+'#'+homeSectionId);
      }else{
        $anchor.attr('href',onePageUrl);
      }
    }else{
      if (typeof splitUrl !== undefined){
        $anchor.attr('href',onePageUrl+'#'+splitUrl[1]);
      };
    }
  });

  //one page nav with smoth scroll and active nav
  $('.sp-megamenu-parent, .nav.menu').onePageNav({
    currentClass: 'active',
    changeHash: false,
    scrollSpeed: 900,
    scrollOffset: 30,
    scrollThreshold: 0.5,
    filter: ':not(.no-scroll)'
  });
  //Mega Menu
  $('.sp-megamenu-wrapper').parent().parent().css('position','static').parent().css('position', 'relative');
  $('.sp-menu-full').each(function(){
    $(this).parent().addClass('menu-justify');
  });

  $(document).ready(function(){
    var spHeader = $("#sp-header");
    if ($("body.com-sppagebuilder #sp-page-builder .lead-landing").length) {
      spHeader.addClass('has-jlead-landing');
    }
    spHeader.addClass('menu-fixed-out');
  });

  var windowWidth = $(window).width();

  var stickyNavTop = $('#sp-header').offset().top;

  var stickyNav = function(){
    var scrollTop = $(window).scrollTop();

    if (scrollTop > stickyNavTop) {
      $('#sp-header').removeClass('menu-fixed-out')
      .addClass('menu-fixed');
    }
    else
    {
      if($('#sp-header').hasClass('menu-fixed'))
      {
        $('#sp-header').removeClass('menu-fixed').addClass('menu-fixed-out');
      }
    }
  };

  stickyNav();

  $(window).scroll(function() {
    stickyNav();
  });

  //Tooltip
  $('[data-toggle="tooltip"]').tooltip();

  $(document).on('click', '.sp-rating .star', function(event) {
    event.preventDefault();

    var data = {
      'action':'voting',
      'user_rating' : $(this).data('number'),
      'id' : $(this).closest('.post_rating').attr('id')
    };

    var request = {
      'option' : 'com_ajax',
      'plugin' : 'helix3',
      'data'   : data,
      'format' : 'json'
    };

    $.ajax({
      type   : 'POST',
      data   : request,
      beforeSend: function(){
        $('.post_rating .ajax-loader').show();
      },
      success: function (response) {
        var data = $.parseJSON(response.data);

        $('.post_rating .ajax-loader').hide();

        if (data.status == 'invalid') {
          $('.post_rating .voting-result').text('You have already rated this entry!').fadeIn('fast');
        }else if(data.status == 'false'){
          $('.post_rating .voting-result').text('Somethings wrong here, try again!').fadeIn('fast');
        }else if(data.status == 'true'){
          var rate = data.action;
          $('.voting-symbol').find('.star').each(function(i) {
            if (i < rate) {
              $( ".star" ).eq( -(i+1) ).addClass('active');
            }
          });

          $('.post_rating .voting-result').text('Thank You!').fadeIn('fast');
        }

      },
      error: function(){
        $('.post_rating .ajax-loader').hide();
        $('.post_rating .voting-result').text('Failed to rate, try again!').fadeIn('fast');
      }
    });
  });
  //INIT 3RD JS
  var App = { init: function() {
    App.Fit_Vids();
    App.Nivo_Lightbox();
    App.Reviews();
  },
  Nivo_Lightbox: function() {
    $('#Play_Video').nivoLightbox({
      effect: 'slideDown',
      afterHideLightbox: function(){ $('#video_modal_box iframe').attr("src", jQuery("#video_modal_box iframe").attr("src"));}
    });
    $('.mdl-card__menu a').nivoLightbox({effect: 'slideDown'});
  },
  // Fit Vids
  Fit_Vids: function() {
    $("#video_modal_box").fitVids();
  },
  Fastclick: function() {
    FastClick.attach(document.body);
  },
  // Reviews Carousel
  Reviews: function() {
    $(".owl-carousel").owlCarousel({
      loop:true,
      singleItem : true,
    });
  },
  ContactForm: function() {
    "use strict";
    var options = {target: "#alert"}
    $("#contact-form").ajaxForm(options);
  },
}
$(function() {
  App.init();
  $(window).resize(App.setHeight);

});
});
